/* shell.c
 *
 * The routines in this file generater an
 * opiionated shell script.
 *
 * written by vx-clutch
 */

#include <sys/stat.h>
#include <sys/types.h>

#include "estruct.h"
#include "file.h"
#include "full.h"
#include "edef.h"
#include "input.h"
#include "shell.h"
#include "single.h"
#include "usage.h"

int makeshell(char *src, int complexity) {
  char *license = LICENSE;

  if (complexity == SINGLE)
    single_init(src);
  else if (complexity == FULL) {
    full_project_init_and_cd(src);
  }
  else
    die("invalid state! shell.c:%d", __LINE__);

  if (!QLICENSE)
    license = getstring("License");
  char *description = getstring("Description");

  ffwrite(src, "\
#!/bin/sh\n\
# SPDX-License-Identifier: %s\n\
#\n\
# %s\n\
\n\
me=$0\n\
scriptversion=\"1.0.0\"\n\
\n\
version=\"$me $scriptversion\n\
\n\
Copyright (C) %d %s.\n\
This is free software; you are free to change and redistribute it.\n\
There is NO WARRANTY, to the extent permitted by law.\"\n\
\n\
usage=\"\\\n\
Usage: $me [OPTION]...\n\
%s\n\
\n\
Options:\n\
   --help     print this help and exit\n\
   --version  output version information\n\"\n\
\n\
while [ $# -gt 0 ]; do\n\
  case $1 in\n\
    --help) echo \"$usage\"; exit 0 ;;\n\
    --version) echo \"$version\"; exit 0 ;;\n\
    -*)\n\
      echo \"$0: Unknown option '$1'.\" >&2\n\
      echo \"$0: Try '--help' for more information.\" >&2\n\
      exit 1 ;;\n\
  esac\n\
  shift\n\
done",
          license, description, 2025, "fSD", description);

  struct stat st;
  if (stat(src, &st) == 0)
    chmod(src, st.st_mode | S_IXUSR | S_IXGRP | S_IXOTH);

  return 0;
}
