/* proj.c
 *
 * The routines in this file generater an
 * opinionated C project.
 *
 * written by vx-clutch
 */

#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "estruct.h"
#include "wrapper.h"
#include "file.h"
#include "input.h"
#include "proj.h"
#include "usage.h"
#include "util.h"
#include "version.h"

int makeproj(char *src) {
  if (ffexist(src))
    die("%s already exists", src);

  fmkdir(src);
  if (chdir(src))
    die("could not cd into %s", src);

  int year = getyear();
  char *author = getstring("Author");
  char *description = getstring("Description");

  ffwrite("main.c", "\
/*\n\
 * main.c\n\
 *\n\
 * %s/%s 1.0\n\
 *\n\
 * Copying policy\n\
 *\n\
 * %s 1.0 can be copied and distributed freely for any\n\
 * non-commercial purposes. %s 1.0 can only be incorporated\n\
 * into commercial software with the permission of the current author.\n\
 *\n\
 * This file contains the main driving routine.\n\
 *\n\
 */\n\
\n\
#include <stdio.h>\n\
#include <stdlib.h>\n\
#include <string.h>\n\
\n\
#include \"version.h\"\n\
#include \"estruct.h\"\n\
\n\
void usage(int status)\n\
{\n\
  printf(\"Usage: %%s REQUIRED POSITIONAL ARGUMENT\\n\", PROGRAM_NAME);\n\
  printf(\"   or: %%s [options]\\n\\n\", PROGRAM_NAME);\n\
  fputs(\"      --help     display this help and exit\\n\", stdout);\n\
  fputs(\"      --version  output version information and exit\\n\", stdout);\n\
\n\
  exit(status);\n\
}\n\
\n\
int main(int argc, char **argv)\n\
{\n\
  int carg;\n\
\n\
  if (argc == 2) {\n\
    if (strcmp(argv[1], \"--help\") == 0) {\n\
      usage(EXIT_FAILURE);\n\
    }\n\
    if (strcmp(argv[1], \"--version\") == 0) {\n\
      version();\n\
      exit(EXIT_SUCCESS);\n\
    }\n\
  }\n\
\n\
  puts(MESSAGE);\n\
\n\
  return 0;\n\
}", src, author, src, src);

  size_t len = strlen(src) + 1 + strlen(author) + 6; /* account for " 1.0 " */
  char *pad = xmalloc(len + 1);
  memset(pad, '-', len);
  pad[len] = '\0';
  ffwrite("README", "\
+%s+\n\
| %s/%s 1.0 |\n\
+%s+\n\
\n\
	%s\n\
\n\
	%s was written by %s\n\
\n\
	Copyright Notices:\n\
\n\
	%s 1.0 (c) Copyright %d %s\n\
\n\
	Reference the COPYING file for detailed information\n\
\n\
\n\
WHAT IS %s/%s?\n\
\n\
%s/%s 1.0 %s\n\
\n\
\n\
WHAT IS NEW\n\
\n\
Features:\n\
\n\
o  This is the first version, EVERYTHING is new!\n\
\n\
Bug fixes - not very interesting:\n\
\n\
o  None\n\
\n\
Something is gone:\n\
\n\
o  None\n\
\n\
HOW TO INSTALL %s/%s?\n\
\n\
o  UNIX: Look at estruct.h, do a 'make', test the program, 'make install'.\n\
\n\
\n\
ACKNOWLEDGEMENTS AND STATUS\n\
\n\
This project's file strucutre, file format, and certain contents are\n\
derived from uEmacs/PK 4.0 specifically from the Linux Torvalds\n\
distribution on GitHub. The README on from uEmacs/PK 4.0 has greater and\n\
more accurate attributions, if you desire.\n\
\n\
%s was generated using %s %s\n\
\n\
LAST MODIFED DATE\
",
          pad,
          src, author,
          pad,
	  description,
	  src, author,
	  src, year, author,
	  src, author,
	  src, author, description,
	  src, author,
	  src, PROGRAM_NAME_LONG, VERSION);

  ffwrite("version.h", "\
#ifndef VERSION_H_\n\
#define VERSION_H_\n\
\n\
#define PROGRAM_NAME \"%s\"\n\
#define PROGRAM_NAME_LONG \"%s/%s\"\n\
\n\
#define  VERSION  \"1.0.0\"\n\
\n\
/* Print the version string. */\n\
void version(void);\n\
\n\
#endif  /* VERSION_H_ */", src, src, author);
  ffwrite("version.c", "\
#include <stdio.h>\n\
#include \"version.h\"\n\
\n\
void version(void)\n\
{\n\
	printf(\"%%s version %%s\\n\", PROGRAM_NAME_LONG, VERSION);\n\
}");

  ffwrite("Makefile", "\
# Makefile for %s\n\
\n\
# Make the build silent by default\n\
V =\n\
\n\
ifeq ($(strip $(V)),)\n\
	E = @echo\n\
	Q = @\n\
else\n\
	E = @\\#\n\
	Q =\n\
endif\n\
export E Q\n\
\n\
PROGRAM = %s\n\
TARBALL = $(PROGRAM).tar\n\
SRC     = $(wildcard *.c)\n\
OBJ     = $(SRC:.c=.o)\n\
HDR     = $(wildcard *.h)\n\
\n\
CC       = gcc\n\
WARNINGS = -Wall -Wstrict-prototypes\n\
CFLAGS   = -O2 $(WARNINGS) -g\n\
DEFINES  =\n\
LIBS     =\n\
LDFLAGS  =\n\
BINDIR   = /usr/bin\n\
LIBDIR   = /usr/lib\n\
\n\
$(PROGRAM): $(OBJ) $(HDR)\n\
	$(E) \"  LINK    \" $@\n\
	$(Q) $(CC) $(LDFLAGS) $(DEFINES) -o $@ $(OBJ) $(LIBS)\n\
\n\
clean:\n\
	$(E) \"  CLEAN\"\n\
	$(Q) rm -f $(PROGRAM) $(OBJ)\n\
\n\
install: $(PROGRAM)\n\
	cp $(PROGRAM) ${BINDIR}\n\
\n\
release: $(PROGRAM)\n\
	tar cvf $(TARBALL) $(SRC) $(HDR) Makefile README\n\
\n\
.c.o:\n\
	$(E) \"  CC      \" $@\n\
	$(Q) $(CC) $(CFLAGS) $(DEFINES) -c $< -o $@", src, src);

  ffwrite("usage.h", "\
#ifndef USAGE_H_\n\
#define USAGE_H_\n\
\n\
void die(const char* err, ...);\n\
\n\
#endif  /* USAGE_H_ */");
  ffwrite("usage.c", "\
#include \"usage.h\"\n\
\n\
#include <stdarg.h>\n\
#include <stdio.h>\n\
#include <stdlib.h>\n\
\n\
static void report(const char* prefix, const char *err, va_list params)\n\
{\n\
  char msg[4096];\n\
  vsnprintf(msg, sizeof(msg), err, params);\n\
  fprintf(stderr, \"%%s%%s\\n\", prefix, msg);\n\
}\n\
\n\
void die(const char* err, ...)\n\
{\n\
  va_list params;\n\
\n\
  va_start(params, err);\n\
  report(\"fatal: \", err, params);\n\
  va_end(params);\n\
  exit(128);\n\
}");

  ffwrite("estruct.h", "\
#ifndef ESTRUCT_H_\n\
#define ESTRUCT_H_\n\
\n\
/* Configuration options */\n\
\n\
#define MESSAGE \"Hello, World!\" /* Default greeting */\n\
\n\
#endif  /* ESTRUCT_H_ */");

  return 0;
}
