/*
 * main.c
 *
 * yait/fSD 1.0
 *
 * Copying policy:
 *
 * yait 1.0 can be copied and distributed freely for any
 * non-commercial purposes. yait 1.0 can only be incorporated
 * into commercial software with the permission of the current author.
 *
 * This file contains the main driving routine, and some handling
 * for C/SH distinction.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>

#include "edef.h"
#include "proj.h"
#include "shell.h"
#include "usage.h"
#include "version.h"

void usage(int status) {
  printf("Usage: %s filename\n", PROGRAM_NAME);
  printf("   or: %s [options]\n\n", PROGRAM_NAME);
  fputs("      -s         enable shell creation mode\n", stdout);
  fputs("      -S         enable shell creation mode as a full project\n", stdout);
  fputs("      --git      initialize a git repository\n", stdout);
  fputs("      --help     display this help and exit\n", stdout);
  fputs("      --version  output version information and exit\n", stdout);

  exit(status);
}

int main(int argc, char **argv) {
  int shell_mode = 0;
  char *package = NULL;
  int carg;

  if (argc < 2)
    die("not enough arguments");

  if (argc == 2) {
    if (strcmp(argv[1], "--help") == 0)
      usage(EXIT_SUCCESS);
    else if (strcmp(argv[1], "--version") == 0) {
      version();
      exit(EXIT_SUCCESS);
    }
  }

  for (carg = 1; carg < argc; ++carg) {
    if (argv[carg][0] == '-') {
      if (argv[carg][1] == 's')
        shell_mode = SINGLE;
      else if (argv[carg][1] == 'S')
        shell_mode = FULL;
      else if (strcmp(argv[carg], "--git"))
	git = 1;
      else
        die("unknown option");
    } else
      package = argv[carg];
  }

  if (!package)
    die("no package name provided");

  if (shell_mode)
    makeshell(package, shell_mode);
  else
    makeproj(package);

  return 0;
}
