/* full.c
 *
 * Init to be called before project creation.
 *
 * written by vx-clutch
 */

#include <unistd.h>

#include "file.h"
#include "full.h"
#include "usage.h"
#include "git.h"

int full_project_init_and_cd(char *src)
{
  if (ffexist(src))
    die("%s already exists", src);

  fmkdir(src);
  if (chdir(src))
	  die("could not cd into %s", src);

  // TODO(vx-clutch): Take in interactive arguments all at once
  ffwrite("README", "\
+--------------------+\n\
| package/Author 1.0 |\n\
+--------------------+\n\
\n\
        A project that does a thing 'well'.\n\
\n\
        %s was written by ME!!!\n\
\n\
        Copyright Notices:\n\
\n\
        %s 1.0 (c) Copyright 2025 Author. \n\
  Reference the COPYING file for detailed information\n\
\n\
\n\
WHAT IS package/Author?\n\
\n\
package/Author 1.0 is an optionated C and SH project generator. For C project\n\
generation is produces a similar layout to the source of this project. On\n\
SH it generates a shell script with useful useful scaffolding for a\n\
script.\n\
\n\
\n\
WHAT IS NEW\n\
\n\
Features:\n\
\n\
o  This is the inital commit, EVERYTHING is new!\n\
\n\
Bug fixes - not very interesting:\n\
\n\
o  None\n\
\n\
Something is gone:\n\
\n\
o  None\n\
\n\
HOW TO INSTALL package/Author?\n\
\n\
o  UNIX: Look at estruct.h, do a 'make', test the program, 'make install'.\n\
\n\
\n\
ACKNOWLEDGEMENTS AND STATUS\n\
\n\
This project's file strucutre, file format, and certain contents are\n\
derived from uEmacs/PK 4.0 specifically from the Linux Torvalds\n\
distribution on GitHub. The README on from uEmacs/PK 4.0 has greater and\n\
more accurate attributions, if you desire.\n\
\n\
LATE MODIFIED DATE", src, src);

  ginit(); /* initialize a git repository */

  return 0;
}
