/*  file.c
 *
 *  The routines in this file handle the reading, writing
 *  and lookup of disk files.
 *
 *  written by vx-clutch
 */

#include <errno.h>
#include <libgen.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "file.h"
#include "estruct.h"

int ffwrite(char *path, char *fmt, ...) {
  FILE *f;
  va_list ap;
  int r;

  f = fopen(path, "w");
  if (!f)
    return -1;

  va_start(ap, fmt);
  r = vfprintf(f, fmt, ap);
  va_end(ap);

  fclose(f);
  return r < 0 ? -1 : 0;
}

int fmkdir(char *fmt, ...)
{
  va_list ap;
  char path[NPAT];
  char tmp[NPAT];
  char *p;

  va_start(ap, fmt);
  vsnprintf(path, sizeof(path), fmt, ap);
  va_end(ap);

  strncpy(tmp, path, sizeof(tmp) - 1);
  tmp[sizeof(tmp) - 1] = '\0';

  for (p = tmp + 1; *p; p++) {
    if (*p == '/') {
      *p = '\0';
      if (mkdir(tmp, 0755) < 0 && errno != EEXIST)
        return -1;
      *p = '/';
    }
  }

  if (mkdir(tmp, 0755) < 0 && errno != EEXIST)
    return -1;

  return 0;
}

int ffexist(char *fmt, ...) {
  char path[NPAT];
  va_list ap;
  struct stat st;

  va_start(ap, fmt);
  vsnprintf(path, sizeof(path), fmt, ap);
  va_end(ap);

  return stat(path, &st) == 0;
}
